<?php
include 'header.php';

$msg = "";
$err = "";
$investmentId = "";
$status = "";

if (isset($_POST['investment_submit'])) {
    $investmentId = $link->real_escape_string($_POST['investment_id']);
    $status = $link->real_escape_string($_POST['status']);
    $progress = (int) $_POST['progress'];

    // Fetch investment details
    $sqlGet = "SELECT * FROM investments WHERE id='$investmentId'";
    $res = mysqli_query($link, $sqlGet);
    if (mysqli_num_rows($res) > 0) {
        $investment = mysqli_fetch_assoc($res);
        $username = $investment['username'];
        $roi = $investment['roi'];
        $amount = $investment['amount'];

        // Update status and progress
        $sqlUpdate = "UPDATE investments SET status='$status', progress='$progress' WHERE id='$investmentId'";
        if (mysqli_query($link, $sqlUpdate)) {
            // If completed, add ROI (percentage of amount) to user's walletbalance
            if ($status === "completed") {
                $roi_amount = ($amount * $roi) / 100;
                $sqlUser = "UPDATE users SET walletbalance = walletbalance + '$roi_amount' WHERE username='$username'";
                mysqli_query($link, $sqlUser);
            }
            $msg = "Investment updated successfully!";
        } else {
            $err = mysqli_error($link);
        }
    } else {
        $err = "Investment not found!";
    }
}


// Load investment for edit
if (isset($_GET['id']) && $_GET['id'] != '') {
    $investmentId = $link->real_escape_string($_GET['id']);
    $sqlGet = "SELECT * FROM investments WHERE id='$investmentId'";
    $result = mysqli_query($link, $sqlGet);
    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $status = $row['status'];
    }
}

// Handle delete
if (isset($_GET['delete']) && $_GET['delete'] != '') {
    $deleteId = $link->real_escape_string($_GET['delete']);
    $sqlDelete = "DELETE FROM investments WHERE id='$deleteId'";
    if (mysqli_query($link, $sqlDelete)) {
        $msg = "Investment deleted successfully!";
    } else {
        $err = "Failed to delete investment: " . mysqli_error($link);
    }
}
?>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if ($msg != "") echo customAlert("success", $msg);
        if ($err != "") echo customAlert("error", $err);
        ?>

        <h4 align="center"><i class="fa fa-briefcase"></i> INVESTMENTS MANAGEMENT</h4>
        <br>

        <?php if ($investmentId != "") { ?>
           <form class="form-horizontal" action="investments.php" method="POST">
    <legend>Update Investment</legend>

    <div class="form-group">
        <label>Status</label>
        <select name="status" class="form-control" required>
            <option value="pending" <?php if ($status == "pending") echo "selected"; ?>>Pending</option>
            <option value="active" <?php if ($status == "active") echo "selected"; ?>>Active</option>
            <option value="completed" <?php if ($status == "completed") echo "selected"; ?>>Completed</option>
        </select>
    </div>

    <div class="form-group">
        <label>Progress (%)</label>
        <input type="number" name="progress" class="form-control" min="0" max="100" 
               value="<?php echo isset($row['progress']) ? $row['progress'] : 0; ?>" required>
    </div>

    <input type="hidden" name="investment_id" value="<?php echo $investmentId; ?>">

    <br>
    <button type="submit" class="btn btn-info" name="investment_submit">Update</button>
    <a href="investments.php" class="btn btn-secondary">Cancel</a>
</form>

            <hr>
        <?php } ?>

        <!-- Existing Investments Table -->
        <h5>Existing Investments</h5>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Username</th>
                    <th>Plan ID</th>
                    <th>Wallet ID</th>
                    <th>Amount</th>
                    <th>ROI (%)</th>
                    <th>Referral Bonus (%)</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sqlInvestments = "SELECT * FROM investments ORDER BY id DESC";
                $resInvestments = mysqli_query($link, $sqlInvestments);
                if (mysqli_num_rows($resInvestments) > 0) {
                    $count = 1;
                    while ($rowInv = mysqli_fetch_assoc($resInvestments)) {
                        echo "<tr>
                                <td>".$count++."</td>
                                <td>".htmlspecialchars($rowInv['username'])."</td>
                                <td>".$rowInv['plan_id']."</td>
                                <td>".$rowInv['wallet_id']."</td>
                                <td>".$rowInv['amount']."</td>
                                <td>".$rowInv['roi']."%</td>
                                <td>".$rowInv['ref_bonus_percent']."</td>
                                <td>".$rowInv['status']."</td>
                                <td>".$rowInv['created_at']."</td>
                                <td>
                                    <a href='investments.php?id=".$rowInv['id']."' class='btn btn-sm btn-primary'>Change Status</a>
                                    <a href='investments.php?delete=".$rowInv['id']."' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to delete this investment?')\">Delete</a>
                                </td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='10' align='center'>No investments found.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php
include 'footer.php';
?>
