<?php
include 'header.php';

// Get logged-in username from session
$session_username = $_SESSION['USERLOGIN'] ?? null;

if (!$session_username) {
    echo "<div class='alert alert-danger'>You must be logged in to view your investments.</div>";
    include 'footer.php';
    exit;
}

// Fetch investments with plan/category/wallet details including progress
$query = "
    SELECT i.*, p.name AS plan_name, c.name AS category_name, w.name AS wallet_name
    FROM investments i
    LEFT JOIN plan_categories c ON i.plan_id = c.id
    LEFT JOIN wallet w ON i.wallet_id = w.id
    LEFT JOIN investment_plans p ON i.plan_id = p.id
    WHERE i.username = '".mysqli_real_escape_string($link, $session_username)."'
    ORDER BY i.created_at DESC
";
$result = mysqli_query($link, $query);
?>

<div id="content" class="content">
  <h1 class="page-header mb-3">
    <i class="fas fa-chart-line"></i> My Investments
  </h1>

  <?php if (isset($_GET['saved'])) { ?>
    <div class="alert alert-success">Your investment has been added successfully.</div>
  <?php } ?>

  <div class="panel panel-inverse">
    <div class="panel-heading">
      <h4 class="panel-title">Investment History</h4>
    </div>
    <div class="panel-body">

      <?php if (mysqli_num_rows($result) > 0) { ?>
        <div class="table-responsive">
          <table class="table table-striped table-bordered">
            <thead class="thead-dark">
              <tr>
                <th>#</th>
                <th>Plan</th>
                <th>Category</th>
                <th>Wallet</th>
                <th>Amount</th>
                <th>ROI (%)</th>
                <th>Referral Bonus (%)</th>
                <th>Status</th>
                <th>Progress</th>
                <th>Created At</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php 
              $count = 1;
              while ($row = mysqli_fetch_assoc($result)) { 
                  // Use the progress value stored in DB
                  $progress = isset($row['progress']) ? (int)$row['progress'] : 0;
                  if ($row['status'] == 'completed') {
                      $progress = 100;
                  }
              ?>
                <tr>
                  <td><?php echo $count++; ?></td>
                  <td><?php echo htmlspecialchars($row['plan_name'] ?? 'N/A'); ?></td>
                  <td><?php echo htmlspecialchars($row['category_name'] ?? 'N/A'); ?></td>
                  <td><?php echo htmlspecialchars($row['wallet_name'] ?? 'N/A'); ?></td>
                  <td><?php echo number_format($row['amount'], 2); ?></td>
                  <td><?php echo $row['roi']; ?>%</td>
                  <td><?php echo $row['ref_bonus_percent']; ?>%</td>
                  <td>
                    <?php if ($row['status'] == 'active') { ?>
                      <span class="badge bg-success">Active</span>
                    <?php } elseif ($row['status'] == 'completed') { ?>
                      <span class="badge bg-primary">Completed</span>
                    <?php } else { ?>
                      <span class="badge bg-secondary"><?php echo ucfirst($row['status']); ?></span>
                    <?php } ?>
                  </td>
                  <td>
                    <div class="progress" style="height:20px;">
                      <div class="progress-bar 
                          <?php echo ($progress < 50 ? 'bg-warning' : 'bg-info'); ?>" 
                        role="progressbar" 
                        style="width: <?php echo $progress; ?>%;" 
                        aria-valuenow="<?php echo $progress; ?>" aria-valuemin="0" aria-valuemax="100">
                        <?php echo $progress; ?>%
                      </div>
                    </div>
                  </td>
                  <td><?php echo date("M d, Y H:i", strtotime($row['created_at'])); ?></td>
                  <td>
                    <?php if ($row['status'] == 'active') { ?>
                      <a href="cancel_investment.php?id=<?php echo $row['id']; ?>" 
                         class="btn btn-danger btn-sm"
                         onclick="return confirm('Are you sure you want to cancel this investment?');">
                        Cancel
                      </a>
                    <?php } else { ?>
                      <span class="text-muted">N/A</span>
                    <?php } ?>
                  </td>
                </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      <?php } else { ?>
        <p class="text-center text-muted">No investments found.</p>
      <?php } ?>

    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
