<?php
session_start();
include "header.php";

if (!isset($_SESSION['USERLOGIN'])) {
    header("Location: login.php");
    exit();
}

$msg = "";
$err = "";

// Handle AI bot purchase
if (isset($_POST['buy_bot'])) {
    $plan_id = intval($_POST['plan_id']);
    $amount  = floatval($_POST['amount']);
    $created = date('Y-m-d H:i:s');

    // Get plan info
    $plan = mysqli_fetch_assoc(mysqli_query($link, "SELECT * FROM ai_trading_plans WHERE id='$plan_id'"));
    if (!$plan) {
        $err = "Invalid plan selected.";
    } elseif ($amount < $plan['min_invest'] || $amount > $plan['max_invest']) {
        $err = "Amount must be between $" . number_format($plan['min_invest']) . " and $" . number_format($plan['max_invest']) . ".";
    } else {
        $sql = "INSERT INTO ai_trading_bots (user_id, plan_id, amount_invested, daily_profit, duration, status, created_at)
                VALUES ('$uid', '$plan_id', '$amount', '{$plan['daily_profit']}', '{$plan['duration']}', 'active', '$created')";
        if (mysqli_query($link, $sql)) {
            //$msg = "AI Trading Bot activated successfully!";
            echo "<script>alert('AI Trading Bot activated successfully!')</script>";
            
        } else {
            $err = "Database error: " . mysqli_error($link);
        }
    }
}
?>

<style>
label {
    color: white !important;
}
.card-title {
    color: white;
}
.bot-card {
    background: rgba(255,255,255,0.05);
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 20px;
    border: 1px solid rgba(255,255,255,0.1);
}
.buy-btn {
    background: dodgerblue;
    color: #fff;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    font-weight: bold;
    width: 100%;
}
.buy-btn:hover {
    opacity: 0.9;
}
.table th, .table td {
    color: white;
}
</style>

<div class="page-content">
    <div class="container">
        <?php 
        if ($msg != "") echo customAlert("success", $msg);
        if ($err != "") echo customAlert("error", $err);
        ?>

        <div class="row">
            <div class="col-lg-10 offset-lg-1">
                <div class="card mb-5">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Available AI Trading Bots</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php
                            $plans = mysqli_query($link, "SELECT * FROM ai_trading_plans ORDER BY id ASC");
                            if (mysqli_num_rows($plans) > 0) {
                                while ($plan = mysqli_fetch_assoc($plans)) {
                                    echo '
                                    <div class="col-md-6 col-lg-4">
                                        <div class="bot-card text-center">
                                            <h5 style="color:#00BFFF;">' . htmlspecialchars($plan['plan_name']) . '</h5>
                                            <p style="color:white;">' . htmlspecialchars($plan['description']) . '</p>
                                            <p style="color:white;">
                                                <b>Min:</b> $' . number_format($plan['min_invest']) . '<br>
                                                <b>Max:</b> $' . number_format($plan['max_invest']) . '<br>
                                                <b>Daily Profit:</b> $' . number_format($plan['daily_profit']) . '<br>
                                                <b>Duration:</b> ' . htmlspecialchars($plan['duration']) . ' days
                                            </p>
                                            <form method="post" action="">
                                                <input type="hidden" name="plan_id" value="' . $plan['id'] . '">
                                                <div class="mb-2">
                                                    <label>Enter Amount ($)</label>
                                                    <input type="number" step="0.01" name="amount" min="' . $plan['min_invest'] . '" max="' . $plan['max_invest'] . '" required class="form-control" style="color:black;">
                                                </div>
                                                <button type="submit" name="buy_bot" class="buy-btn">Activate Bot</button>
                                            </form>
                                        </div>
                                    </div>';
                                }
                            } else {
                                echo "<p class='text-center text-white'>No AI trading bots available at the moment.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- Active AI Bots -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">My Active AI Bots</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Bot Name</th>
                                    <th>Amount ($)</th>
                                    <th>Daily Profit ($)</th>
                                    <th>Duration (Days)</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $bots = mysqli_query($link, "SELECT b.*, p.plan_name FROM ai_trading_bots b 
                                                            JOIN ai_trading_plans p ON b.plan_id = p.id 
                                                            WHERE b.user_id='$uid' ORDER BY b.id DESC");
                                if (mysqli_num_rows($bots) > 0) {
                                    while ($row = mysqli_fetch_assoc($bots)) {
                                        echo "<tr>
                                            <td>{$row['id']}</td>
                                            <td>{$row['plan_name']}</td>
                                            <td>\${$row['amount_invested']}</td>
                                            <td>\${$row['daily_profit']}</td>
                                            <td>{$row['duration']}</td>
                                            <td>{$row['status']}</td>
                                            <td>{$row['created_at']}</td>
                                        </tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='7' class='text-center'>No active AI bots yet</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?php include "footer.php"; ?>
