<?php 
include 'header.php';
$msg ="";
$err = "";

// Handle approve/reject actions
if (isset($_GET['action'], $_GET['id'])) {
    $id = intval($_GET['id']);
    $action = $_GET['action'];

    if ($action == "approve") {
        $update = mysqli_query($link, "UPDATE kyc_table SET status='approved' WHERE id='$id'");
        if ($update) {
            $msg = "KYC Approved successfully";
        } else {
            $err = mysqli_error($link);
        }
    } elseif ($action == "reject") {
        $update = mysqli_query($link, "UPDATE kyc_table SET status='rejected' WHERE id='$id'");
        if ($update) {
            $msg = "KYC Rejected successfully";
        } else {
            $err = mysqli_error($link);
        }
    }
}

// Fetch all KYC submissions
$kyc_query = mysqli_query($link, "SELECT k.*, u.fname, u.email, u.username 
                                  FROM kyc_table k 
                                  JOIN users u ON k.user_id = u.id 
                                  ORDER BY k.created_at DESC");
?>

<div class="page-content">
    <div class="container-fluid">
<?php 
  if ($msg != "") {
    echo customAlert("success", $msg);
    echo pageRedirect("2", "kyc.php");
  }
  if ($err != "") {
    echo customAlert("error", $err);
  }
?>

      <div class="row">
            <div class="col-lg-12">
                <div class="card">
                  <div class="card-body">
                    <div class="card-header">
                      <h4 class="card-title mb-0">KYC Submissions</h4>
                  </div>

                  <div class="table-responsive">
                      <table class="table table-striped table-bordered">
                          <thead>
                              <tr>
                                  <th>ID</th>
                                  <th>User</th>
                                  <th>Email</th>
                                  <th>Full Name</th>
                                  <th>DOB</th>
                                  <th>Address</th>
                                  <th>ID Type</th>
                                  <th>ID Number</th>
                                  <th>Document</th>
                                  <th>Status</th>
                                  <th>Submitted At</th>
                                  <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                              <?php while ($row = mysqli_fetch_assoc($kyc_query)) { ?>
                                  <tr>
                                      <td><?php echo $row['id']; ?></td>
                                      <td><?php echo $row['username']; ?></td>
                                      <td><?php echo $row['email']; ?></td>
                                      <td><?php echo $row['full_name']; ?></td>
                                      <td><?php echo $row['dob']; ?></td>
                                      <td><?php echo $row['address']; ?></td>
                                      <td><?php echo $row['id_type']; ?></td>
                                      <td><?php echo $row['id_number']; ?></td>
                                      <td>
                                          <?php if ($row['id_file']) { ?>
                                              <a href="../uploads/kyc/<?php echo $row['id_file']; ?>" target="_blank">View</a>
                                          <?php } ?>
                                      </td>
                                      <td>
                                          <?php 
                                            if ($row['status'] == 'pending') {
                                                echo "<span class='badge bg-warning'>Pending</span>";
                                            } elseif ($row['status'] == 'approved') {
                                                echo "<span class='badge bg-success'>Approved</span>";
                                            } else {
                                                echo "<span class='badge bg-danger'>Rejected</span>";
                                            }
                                          ?>
                                      </td>
                                      <td><?php echo $row['created_at']; ?></td>
                                      <td>
                                          <?php if ($row['status'] == 'pending') { ?>
                                              <a href="kyc.php?action=approve&id=<?php echo $row['id']; ?>" class="btn btn-success btn-sm">Approve</a>
                                              <a href="kyc.php?action=reject&id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm">Reject</a>
                                          <?php } ?>
                                      </td>
                                  </tr>
                              <?php } ?>
                          </tbody>
                      </table>
                  </div>

                    </div>
                </div>
            </div>
        </div>
  </div>
</div>

<?php 
include 'footer.php';
?>
