<?php
include 'header.php'; 
?>

<?php 
$msg = "";
$err = "";

if (isset($_POST['send'])) {
    // Sanitize inputs
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);
    $res = trim($_POST['res']);

    if (!empty($subject) && !empty($res) && !empty($message)) {

        // Prepare HTML message body
        $htmlMessage = '
        <html>
        <head><title>' . htmlspecialchars($subject) . '</title></head>
        <body style="background: #f5f7f8; font-family: sans-serif;">
            <div style="background:#fff; max-width:600px; margin:20px auto; padding:30px; border-radius:10px;">
                <div style="background:red; color:#fff; padding:20px; text-align:center;">
                    <h1 style="margin:0;">' . htmlspecialchars($subject) . '</h1>
                </div>
                <div style="padding:20px; color:#333;">
                    <p style="line-height:25px;">' . nl2br(htmlspecialchars($message)) . '</p>
                </div>
            </div>
        </body>
        </html>
        ';

        // Set headers
        $fromEmail = "noreply@" . $_SERVER['SERVER_NAME'];
        $headers = "From: " . $fromEmail . "\r\n";
        $headers .= "Reply-To: " . $fromEmail . "\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

        // Send the email
        if (@mail($res, $subject, $htmlMessage, $headers)) {
            $msg = "✅ Message successfully sent to $res.";
        } else {
            $err = "❌ Failed to send email. Please check your mail configuration.";
        }
    } else {
        $err = "Please fill in all fields.";
    }
}
?>

<div class="page-content">
    <div class="container-fluid">
        <?php 
        if ($msg != "") {
            echo customAlert("success", $msg);
        }
        if ($err != "") {
            echo customAlert("error", $err);
        }
        ?>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Send Mail to a User</h4>
                        </div>
                        <form method="post" action="mailuser.php">
                            <div class="live-preview">
                                <div class="row gy-4">
                                    <div class="col-xxl-6 col-md-12">
                                        <div>
                                            <label class="form-label">Subject</label>
                                            <input type="text" class="form-control" name="subject" required>
                                        </div>
                                    </div>

                                    <div class="col-xxl-6 col-md-12">
                                        <div>
                                            <label class="form-label">Send mail to</label>
                                            <input type="email" class="form-control" name="res" required>
                                        </div>
                                    </div>

                                    <div class="col-xxl-6 col-md-12">
                                        <div>
                                            <label class="form-label">Message</label>
                                            <textarea class="form-control" rows="5" name="message" placeholder="Type Message..." required></textarea>
                                        </div>
                                    </div>

                                    <div class="col-xxl-6 col-md-12">
                                        <div>
                                            <button type="submit" name="send" class="btn btn-primary">Send</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
