<?php  
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'header.php';

$msg = "";
$err = "";

// ✅ Handle update actions
if (isset($_POST['update'])) {
    $id          = intval($_POST['id']);
    $status      = mysqli_real_escape_string($link, $_POST['status']);
    $profit_loss = floatval($_POST['profit_loss']);

    // Get trade
    $trade_query = mysqli_query($link, "SELECT * FROM trades WHERE id='$id'");
    if ($trade = mysqli_fetch_assoc($trade_query)) {
        $user_id = $trade['user_id'];

        // Update trade
        $update = mysqli_query($link, "UPDATE trades 
                                       SET status='$status', profit_loss='$profit_loss' 
                                       WHERE id='$id'");

        if ($update) {
            // ✅ If trade is closed, credit user wallet
            if ($status == "closed") {
                mysqli_query($link, "UPDATE users 
                                     SET walletbalance = walletbalance + $profit_loss 
                                     WHERE id='$user_id'");
            }
            $msg = "✅ Trade updated successfully!";
        } else {
            $err = mysqli_error($link);
        }
    } else {
        $err = "❌ Trade not found.";
    }
}

// ✅ Fetch all trades and user info
$trades_query = mysqli_query($link, "
    SELECT t.*, u.fname, u.username, u.email 
    FROM trades t 
    JOIN users u ON t.user_id = u.id 
    ORDER BY t.created_at DESC
");
?>

<div class="page-content">
  <div class="container-fluid">

    <?php 
    if ($msg != "") {
        echo customAlert("success", $msg);
        echo pageRedirect("2", "manage-trades.php");
    }
    if ($err != "") {
        echo customAlert("error", $err);
    }
    ?>

    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="card-header">
              <h4 class="card-title mb-0">User Trades</h4>
            </div>

            <div class="table-responsive">
              <table class="table table-striped table-bordered">
                <thead class="table-dark">
                  <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Asset</th>
                    <th>Amount ($)</th>
                    <th>Status</th>
                    <th>Profit/Loss ($)</th>
                    <th>Opened At</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                <?php 
                if (mysqli_num_rows($trades_query) > 0) {
                    while ($row = mysqli_fetch_assoc($trades_query)) { ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo htmlspecialchars($row['fname']); ?></td>
                            <td><?php echo htmlspecialchars($row['username']); ?></td>
                            <td><?php echo htmlspecialchars($row['email']); ?></td>
                            <td><?php echo htmlspecialchars($row['asset']); ?></td>
                            <td>$<?php echo number_format($row['amount'], 2); ?></td>
                            <td>
                                <?php 
                                    if ($row['status'] == 'open') {
                                        echo "<span class='badge bg-warning'>Open</span>";
                                    } elseif ($row['status'] == 'closed') {
                                        echo "<span class='badge bg-success'>Closed</span>";
                                    } else {
                                        echo "<span class='badge bg-danger'>Rejected</span>";
                                    }
                                ?>
                            </td>
                            <td>$<?php echo number_format($row['profit_loss'], 2); ?></td>
                            <td><?php echo $row['created_at']; ?></td>
                            <td>
                                <form method="post" style="display:inline-block; width:180px;">
                                    <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                    <select name="status" class="form-control form-control-sm mb-2">
                                        <option value="open" <?php if ($row['status']=="open") echo "selected"; ?>>Open</option>
                                        <option value="closed" <?php if ($row['status']=="closed") echo "selected"; ?>>Closed</option>
                                        <option value="rejected" <?php if ($row['status']=="rejected") echo "selected"; ?>>Rejected</option>
                                    </select>
                                    <input type="number" step="0.01" name="profit_loss" class="form-control form-control-sm mb-2" value="<?php echo $row['profit_loss']; ?>" placeholder="Profit/Loss">
                                    <button type="submit" name="update" class="btn btn-primary btn-sm w-100">Update</button>
                                </form>
                            </td>
                        </tr>
                <?php 
                    }
                } else {
                    echo "<tr><td colspan='10' class='text-center'>No trades found</td></tr>";
                }
                ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
