<?php
session_start();
include "header.php";

if (!isset($_SESSION['USERLOGIN'])) {
    header("Location: login.php");
    exit();
}

$msg = "";
$err = "";

// ✅ ensure database connection is available
if (!isset($link) || !$link) {
    die("❌ Database connection not found. Please include your DB connection before header.php");
}

// --- Handle Trade Now form submission ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['expert_id'])) {
    $expert_id = intval($_POST['expert_id']);
    $username = mysqli_real_escape_string($link, $_SESSION['USERLOGIN']);

    // Fetch expert info
    $expert_query = mysqli_query($link, "SELECT * FROM copytrade_experts WHERE id = '$expert_id' LIMIT 1");

    if (mysqli_num_rows($expert_query) > 0) {
        $expert = mysqli_fetch_assoc($expert_query);

        // Check if user already copying this expert
        $check_existing = mysqli_query($link, "SELECT * FROM user_copytrades WHERE username='$username' AND expert_id='$expert_id'");
        if (mysqli_num_rows($check_existing) > 0) {
            $err = "⚠️ You’re already copying this expert.";
        } else {
            // Insert into user_copytrades table
            $start_date = date("Y-m-d H:i:s");
            $expert_name = mysqli_real_escape_string($link, $expert['name']);
            $profit_percent = floatval($expert['profit_percent']);
            $min_deposit = floatval($expert['min_deposit']);

            $insert = mysqli_query($link, "
                INSERT INTO user_copytrades (username, expert_id, expert_name, profit_percent, min_deposit, start_date, status)
                VALUES ('$username', '$expert_id', '$expert_name', '$profit_percent', '$min_deposit', '$start_date', 'active')
            ");

            if ($insert) {
                $msg = "✅ You have successfully started copying {$expert['name']}!";
            } else {
                $err = "❌ Database error: " . mysqli_error($link);
            }
        }
    } else {
        $err = "❌ Expert not found.";
    }
}

// Fetch all copy trade experts
$experts = mysqli_query($link, "SELECT * FROM copytrade_experts ORDER BY id DESC");
?>

<style>
body {
    background: #0b0b16;
}

.copytrade-section {
    background: linear-gradient(135deg, #101021 0%, #1b1b2f 100%);
    padding: 60px 30px 60px 290px;
    min-height: 100vh;
    overflow-x: hidden;
    transition: padding-left 0.3s ease;
    position: relative;
    z-index: 1;
}

@media (max-width: 991px) {
    .copytrade-section {
        padding: 50px 15px;
    }
}

.copytrade-title {
    color: #fff;
    text-align: center;
    margin-bottom: 50px;
    font-size: 2rem;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 1px;
    position: relative;
}

.copytrade-title::after {
    content: "";
    width: 80px;
    height: 4px;
    background: linear-gradient(90deg, #007bff, #00c6ff);
    display: block;
    margin: 12px auto 0;
    border-radius: 2px;
}

.expert-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 18px;
    padding: 25px;
    color: #fff;
    transition: all 0.35s ease;
    position: relative;
    overflow: hidden;
    height: 100%;
}

.expert-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
    border-color: #007bff;
}

.expert-card::before {
    content: "";
    position: absolute;
    top: -40%;
    left: -40%;
    width: 180%;
    height: 180%;
    background: radial-gradient(circle at center, rgba(0, 123, 255, 0.15), transparent 70%);
    opacity: 0;
    transition: opacity 0.4s ease;
    pointer-events: none;
}

.expert-card:hover::before {
    opacity: 1;
}

.expert-header {
    display: flex;
    align-items: center;
    margin-bottom: 15px;
}

.expert-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid #007bff;
    margin-right: 15px;
}

.expert-name {
    font-size: 1.3rem;
    font-weight: 600;
    color: #fff;
    margin: 0;
}

.expert-country {
    font-size: 0.9rem;
    color: #bbb;
}

.expert-stats {
    margin: 10px 0;
    display: flex;
    justify-content: space-between;
    flex-wrap: wrap;
}

.stat-item {
    margin-bottom: 6px;
}

.stat-label {
    color: #999;
    font-size: 0.9rem;
}

.stat-value {
    color: #00c6ff;
    font-weight: 600;
    font-size: 1.1rem;
}

.expert-desc {
    font-size: 0.93rem;
    color: #ccc;
    margin-top: 10px;
    line-height: 1.5;
    min-height: 70px;
}

.trade-btn {
    background: linear-gradient(90deg, #007bff, #00c6ff);
    color: #fff;
    border: none;
    padding: 10px 0;
    border-radius: 10px;
    font-weight: 600;
    transition: 0.3s;
    width: 100%;
    margin-top: 15px;
    letter-spacing: 0.5px;
    position: relative;
    z-index: 2;
    cursor: pointer;
}

.trade-btn:hover {
    background: linear-gradient(90deg, #0056b3, #0099cc);
    transform: scale(1.03);
}
</style>

<div class="page-content">
    <div class="container-fluid copytrade-section">
        <?php 
        if ($msg != "") echo "<div class='alert alert-success'>$msg</div>";
        if ($err != "") echo "<div class='alert alert-danger'>$err</div>";
        ?>

        <h3 class="copytrade-title">Copy Trade Experts</h3>

        <?php if (mysqli_num_rows($experts) > 0): ?>
        <div class="row g-4">
            <?php while ($expert = mysqli_fetch_assoc($experts)) { ?>
                <div class="col-md-6 col-lg-4">
                    <div class="expert-card">
                        <div class="expert-header">
                            <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSysVqYUFfcqpc9SZCc-ST0RueRjp9-EKzmgA&s" class="expert-avatar" alt="Expert">
                            <div>
                                <h5 class="expert-name"><?= htmlspecialchars($expert['name']); ?></h5>
                                <p class="expert-country"><i class="fa fa-globe me-2"></i><?= htmlspecialchars($expert['country']); ?></p>
                            </div>
                        </div>
                        <div class="expert-stats">
                            <div class="stat-item">
                                <p class="stat-label">Profit</p>
                                <p class="stat-value"><?= number_format($expert['profit_percent'], 2); ?>%</p>
                            </div>
                            <div class="stat-item">
                                <p class="stat-label">Min Deposit</p>
                                <p class="stat-value">$<?= number_format($expert['min_deposit'], 2); ?></p>
                            </div>
                        </div>
                        <p class="expert-desc"><?= htmlspecialchars($expert['description']); ?></p>
                        <form method="post">
                            <input type="hidden" name="expert_id" value="<?= $expert['id']; ?>">
                            <button type="submit" class="trade-btn">Trade Now</button>
                        </form>
                    </div>
                </div>
            <?php } ?>
        </div>
        <?php else: ?>
            <p class="text-center text-light mt-5">No experts available yet.</p>
        <?php endif; ?>
    </div>
</div>

<?php include "footer.php"; ?>
